/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.evolvedmekanism.interfaces;

import fr.iglee42.evolvedmekanism.recipes.AlloyerRecipe;
import fr.iglee42.evolvedmekanism.recipes.EMCachedRecipeHelper;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.ingredients.InputIngredient;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.outputs.IOutputHandler;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.TriPredicate;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class ThreeInputCachedRecipe<INPUT_A, INPUT_B, INPUT_C, OUTPUT, RECIPE extends MekanismRecipe>
extends CachedRecipe<RECIPE> {
    private final IInputHandler<INPUT_A> inputHandler;
    private final IInputHandler<INPUT_B> secondaryInputHandler;
    private final IInputHandler<INPUT_C> tertiaryInputHandler;
    private final IOutputHandler<OUTPUT> outputHandler;
    private final Predicate<INPUT_A> inputEmptyCheck;
    private final Predicate<INPUT_B> secondaryInputEmptyCheck;
    private final Predicate<INPUT_C> tertiaryInputEmptyCheck;
    private final Supplier<? extends InputIngredient<INPUT_A>> inputSupplier;
    private final Supplier<? extends InputIngredient<INPUT_B>> secondaryInputSupplier;
    private final Supplier<? extends InputIngredient<INPUT_C>> tertiaryInputSupplier;
    private final TriFunction<INPUT_A, INPUT_B, INPUT_C, OUTPUT> outputGetter;
    private final Predicate<OUTPUT> outputEmptyCheck;
    @Nullable
    private INPUT_A input;
    @Nullable
    private INPUT_B secondaryInput;
    @Nullable
    private INPUT_C tertiaryInput;
    @Nullable
    private OUTPUT output;

    protected ThreeInputCachedRecipe(RECIPE recipe, BooleanSupplier recheckAllErrors, IInputHandler<INPUT_A> inputHandler, IInputHandler<INPUT_B> secondaryInputHandler, IInputHandler<INPUT_C> tertiaryInputHandler, IOutputHandler<OUTPUT> outputHandler, Supplier<InputIngredient<INPUT_A>> inputSupplier, Supplier<InputIngredient<INPUT_B>> secondaryInputSupplier, Supplier<InputIngredient<INPUT_C>> tertiaryInputSupplier, TriFunction<INPUT_A, INPUT_B, INPUT_C, OUTPUT> outputGetter, Predicate<INPUT_A> inputEmptyCheck, Predicate<INPUT_B> secondaryInputEmptyCheck, Predicate<INPUT_C> tertiaryInputEmptyCheck, Predicate<OUTPUT> outputEmptyCheck) {
        super(recipe, recheckAllErrors);
        this.inputHandler = Objects.requireNonNull(inputHandler, "Input handler cannot be null.");
        this.secondaryInputHandler = Objects.requireNonNull(secondaryInputHandler, "Secondary input handler cannot be null.");
        this.tertiaryInputHandler = Objects.requireNonNull(tertiaryInputHandler, "Tertiary input handler cannot be null.");
        this.outputHandler = Objects.requireNonNull(outputHandler, "Output handler cannot be null.");
        this.inputSupplier = Objects.requireNonNull(inputSupplier, "Input ingredient supplier cannot be null.");
        this.secondaryInputSupplier = Objects.requireNonNull(secondaryInputSupplier, "Secondary input ingredient supplier cannot be null.");
        this.tertiaryInputSupplier = Objects.requireNonNull(tertiaryInputSupplier, "Tertiary input ingredient supplier cannot be null.");
        this.outputGetter = Objects.requireNonNull(outputGetter, "Output getter cannot be null.");
        this.inputEmptyCheck = Objects.requireNonNull(inputEmptyCheck, "Input empty check cannot be null.");
        this.secondaryInputEmptyCheck = Objects.requireNonNull(secondaryInputEmptyCheck, "Secondary input empty check cannot be null.");
        this.tertiaryInputEmptyCheck = Objects.requireNonNull(tertiaryInputEmptyCheck, "Tertiary input empty check cannot be null.");
        this.outputEmptyCheck = Objects.requireNonNull(outputEmptyCheck, "Output empty check cannot be null.");
    }

    protected void calculateOperationsThisTick(CachedRecipe.OperationTracker tracker) {
        super.calculateOperationsThisTick(tracker);
        EMCachedRecipeHelper.threeInputCalculateOperationsThisTick(tracker, this.inputHandler, this.inputSupplier, this.secondaryInputHandler, this.secondaryInputSupplier, this.tertiaryInputHandler, this.tertiaryInputSupplier, (input, secondary, tertiary) -> {
            this.input = input;
            this.secondaryInput = secondary;
            this.tertiaryInput = tertiary;
        }, this.outputHandler, this.outputGetter, output -> {
            this.output = output;
        }, this.inputEmptyCheck, this.secondaryInputEmptyCheck, this.tertiaryInputEmptyCheck);
    }

    public boolean isInputValid() {
        Object input = this.inputHandler.getInput();
        if (this.inputEmptyCheck.test(input)) {
            return false;
        }
        Object secondaryInput = this.secondaryInputHandler.getInput();
        if (this.secondaryInputEmptyCheck.test(secondaryInput)) {
            return false;
        }
        Object tertiaryInput = this.tertiaryInputHandler.getInput();
        return !this.tertiaryInputEmptyCheck.test(tertiaryInput) && ((TriPredicate)this.recipe).test(input, secondaryInput, tertiaryInput);
    }

    protected void finishProcessing(int operations) {
        if (!(this.input == null || this.secondaryInput == null || this.tertiaryInput == null || this.output == null || this.inputEmptyCheck.test(this.input) || this.secondaryInputEmptyCheck.test(this.secondaryInput) || this.tertiaryInputEmptyCheck.test(this.tertiaryInput) || this.outputEmptyCheck.test(this.output))) {
            this.inputHandler.use(this.input, operations);
            this.secondaryInputHandler.use(this.secondaryInput, operations);
            this.tertiaryInputHandler.use(this.tertiaryInput, operations);
            this.outputHandler.handleOutput(this.output, operations);
        }
    }

    public static ThreeInputCachedRecipe<@NotNull ItemStack, @NotNull ItemStack, @NotNull ItemStack, @NotNull ItemStack, AlloyerRecipe> alloyer(AlloyerRecipe recipe, BooleanSupplier recheckAllErrors, IInputHandler<@NotNull ItemStack> inputHandler, IInputHandler<@NotNull ItemStack> extraInputHandler, IInputHandler<@NotNull ItemStack> secondExtraInputHandler, IOutputHandler<@NotNull ItemStack> outputHandler) {
        return new ThreeInputCachedRecipe<ItemStack, ItemStack, ItemStack, ItemStack, AlloyerRecipe>(recipe, recheckAllErrors, inputHandler, extraInputHandler, secondExtraInputHandler, outputHandler, recipe::getMainInput, recipe::getExtraInput, recipe::getTertiaryExtraInput, recipe::getOutput, ItemStack::m_41619_, ItemStack::m_41619_, ItemStack::m_41619_, ItemStack::m_41619_);
    }
}

